<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $id = $_POST['id'];
    $name = $_POST['name'];
    $number = $_POST['number'];
    $password = $_POST['password'];

    if (empty($id)) {
        echo "User ID is required";
    } else {
        if (empty($password)) {
            $query = "UPDATE users SET name = ?, number = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssi", $name, $number, $id);
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $query = "UPDATE users SET name = ?, number = ?, password = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sssi", $name, $number, $hashed_password, $id);
        }

        if ($stmt->execute()) {
            echo "User Updated Successfully";
        } else {
            echo "Failed to update user";
        }
        $stmt->close();
    }

} else {
    echo "Invalid Request Method";
}

$conn->close();
?>