<?php 
include 'auth.php'; 
include 'config.php';

// ইউজার ডাটা আনা
$sql = "SELECT * FROM users ORDER BY id DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        body { background-color: #f0f2f5; font-family: 'Poppins', sans-serif; }
        
        /* Navbar Styling */
        .top-header {
            background: white;
            padding: 15px 25px;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 5px rgba(0,0,0,0.02);
        }

        .back-btn {
            text-decoration: none;
            color: #555;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
            background: #f8f9fa;
            padding: 8px 15px;
            border-radius: 30px;
            transition: 0.3s;
            border: 1px solid #eee;
        }
        .back-btn:hover { background: #e9ecef; color: #000; }

        /* Card Design */
        .user-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
            margin-top: 25px;
            overflow: hidden;
            border: none;
        }

        /* Search Box */
        .search-wrapper { position: relative; width: 100%; max-width: 320px; }
        .search-wrapper input {
            padding-left: 40px; border-radius: 50px; border: 1px solid #e0e0e0; background: #fafafa;
        }
        .search-wrapper i {
            position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #999;
        }

        /* Table Design */
        .custom-table thead th {
            background: #f1f3f9; color: #555; text-transform: uppercase;
            font-size: 12px; letter-spacing: 0.5px; padding: 15px; border: none;
        }
        .custom-table tbody td {
            vertical-align: middle; padding: 15px; border-bottom: 1px solid #f5f5f5; color: #444;
        }
        
        .user-icon {
            width: 40px; height: 40px;
            background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
            color: #555; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-weight: bold; font-size: 18px; margin-right: 12px;
        }
        
        .status-badge {
            padding: 5px 12px; border-radius: 20px; font-size: 11px; font-weight: 600;
        }
        .active-badge { background: #e8f5e9; color: #2e7d32; }
        .banned-badge { background: #ffebee; color: #c62828; }

        .btn-action {
            width: 35px; height: 35px; border-radius: 8px;
            display: flex; align-items: center; justify-content: center;
            background: #f0f4ff; color: #4e54c8; transition: 0.3s;
        }
        .btn-action:hover { background: #4e54c8; color: white; }
    </style>
</head>
<body>

    <!-- Header -->
    <div class="top-header">
        <div class="d-flex align-items-center gap-3">
            <a href="dashboard.php" class="back-btn">
                <i class="fas fa-arrow-left"></i> Dashboard
            </a>
            <h5 class="mb-0 fw-bold text-secondary">User List</h5>
        </div>
    </div>

    <div class="container pb-5">
        <div class="user-card">
            
            <!-- Filter Section -->
            <div class="p-4 d-flex flex-wrap justify-content-between align-items-center gap-3">
                <div>
                    <h4 class="fw-bold mb-1">Registered Users</h4>
                    <span class="text-muted small">Total Members: <?php echo $result->num_rows; ?></span>
                </div>
                <div class="search-wrapper">
                    <i class="fas fa-search"></i>
                    <input type="text" id="searchInput" class="form-control" placeholder="Search name or number...">
                </div>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="table custom-table align-middle mb-0">
                    <thead>
                        <tr>
                            <th>User Profile</th>
                            <th>Password</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th class="text-end">Edit</th>
                        </tr>
                    </thead>
                    <tbody id="userTable">
                        <?php while($row = $result->fetch_assoc()) { 
                            $firstLetter = strtoupper(substr($row['name'], 0, 1));
                            $isBanned = ($row['ban_status'] == 'true' || $row['ban_status'] == 'True');
                        ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="user-icon"><?php echo $firstLetter; ?></div>
                                    <div>
                                        <div class="fw-bold text-dark"><?php echo $row['name']; ?></div>
                                        <div class="text-muted small"><?php echo $row['number']; ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="text-muted small" style="font-family: monospace;">
                                    <?php echo substr($row['password'], 0, 10) . '••••••'; ?>
                                </span>
                            </td>
                            <td class="small text-secondary"><?php echo $row['res_date']; ?></td>
                            <td>
                                <?php if($isBanned) { ?>
                                    <span class="status-badge banned-badge">BANNED</span>
                                <?php } else { ?>
                                    <span class="status-badge active-badge">ACTIVE</span>
                                <?php } ?>
                            </td>
                            <td class="text-end">
                                <a href="edit_user.php?id=<?php echo $row['id']; ?>" class="btn-action ms-auto">
                                    <i class="fas fa-pen"></i>
                                </a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <!-- Live Search Script -->
    <script>
        document.getElementById('searchInput').addEventListener('keyup', function() {
            let filter = this.value.toLowerCase();
            let rows = document.querySelectorAll('#userTable tr');
            rows.forEach(row => {
                let text = row.innerText.toLowerCase();
                row.style.display = text.includes(filter) ? '' : 'none';
            });
        });
    </script>
</body>
</html>