<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";

// --- 1. SEND UPDATE (ENABLE) ---
if(isset($_POST['send_update'])){
    $version = mysqli_real_escape_string($conn, $_POST['version']);
    $note = mysqli_real_escape_string($conn, $_POST['note']);
    $url = mysqli_real_escape_string($conn, $_POST['url']);
    
    // Status 'on' হবে
    $sql = "UPDATE app_update SET status='on', version='$version', note='$note', url='$url' WHERE id=1";
    
    if($conn->query($sql)){
        $msg = "<div class='alert alert-success shadow-sm border-0'><i class='fas fa-rocket me-2'></i>New Update Published Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-warning'>Error: " . $conn->error . "</div>";
    }
}

// --- 2. REMOVE UPDATE (DISABLE) ---
if(isset($_POST['remove_update'])){
    // Status 'off' হবে এবং ডাটা রিসেট হবে (আপনার স্কেচওয়্যার লজিক অনুযায়ী)
    $sql = "UPDATE app_update SET status='off', version='0', note='null', url='null' WHERE id=1";
    
    if($conn->query($sql)){
        $msg = "<div class='alert alert-danger shadow-sm border-0'><i class='fas fa-trash-alt me-2'></i>Update Removed Successfully!</div>";
    }
}

// --- 3. FETCH DATA ---
$sql_fetch = "SELECT * FROM app_update WHERE id=1";
$result = $conn->query($sql_fetch);

if($result->num_rows > 0){
    $row = $result->fetch_assoc();
} else {
    // ডিফল্ট রো তৈরি (যদি না থাকে)
    $conn->query("INSERT INTO app_update (id, status, version, url, note) VALUES (1, 'off', '1.0', '', '')");
    $row = array('status'=>'off', 'version'=>'1.0', 'url'=>'', 'note'=>'');
}

// চেক করা আপডেট চালু আছে কিনা
$is_live = ($row['status'] == 'on');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Update Manager</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body { background: #f4f6f9; font-family: 'Poppins', sans-serif; }
        
        /* Navbar */
        .custom-nav { background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%); padding: 15px 0; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .navbar-brand { font-weight: 600; color: white !important; font-size: 1.2rem; }

        /* Card Styles */
        .main-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            border: none;
        }

        /* Status Banner */
        .status-box {
            text-align: center;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 25px;
        }
        .status-live { background: #e0f7fa; color: #006064; border: 1px solid #b2ebf2; }
        .status-off { background: #ffeaa7; color: #d63031; border: 1px solid #fdcb6e; }

        .icon-large { font-size: 40px; margin-bottom: 10px; }

        /* Form Inputs */
        .form-label { font-weight: 600; font-size: 14px; color: #636e72; }
        .form-control {
            border-radius: 10px;
            padding: 12px;
            border: 1px solid #dfe6e9;
            background: #fdfdfd;
        }
        .form-control:focus { background: white; border-color: #0984e3; box-shadow: none; }

        /* Buttons */
        .btn-send {
            background: linear-gradient(135deg, #0984e3 0%, #00cec9 100%);
            border: none; padding: 12px; width: 100%; border-radius: 10px;
            font-weight: 600; color: white; transition: 0.3s;
        }
        .btn-send:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(9, 132, 227, 0.3); }

        .btn-remove {
            background: linear-gradient(135deg, #ff7675 0%, #d63031 100%);
            border: none; padding: 12px; width: 100%; border-radius: 10px;
            font-weight: 600; color: white; transition: 0.3s;
        }
        .btn-remove:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(214, 48, 49, 0.3); }

    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-dark custom-nav mb-5">
        <div class="container">
            <span class="navbar-brand"><i class="fas fa-cloud-upload-alt me-2"></i>Update Manager</span>
            <a href="dashboard.php" class="btn btn-outline-light btn-sm rounded-pill px-3">Back Home</a>
        </div>
    </nav>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                
                <?php echo $msg; ?>

                <div class="main-card">
                    
                    <?php if($is_live) { ?>
                        <!-- যদি আপডেট চালু থাকে (Live Mode) -->
                        <div class="status-box status-live">
                            <i class="fas fa-check-circle icon-large"></i>
                            <h4>Update is Live!</h4>
                            <p class="mb-0">Version: <strong><?php echo $row['version']; ?></strong> is available for users.</p>
                        </div>

                        <div class="alert alert-light border">
                            <small class="text-muted d-block fw-bold">Current Release Note:</small>
                            <?php echo nl2br($row['note']); ?>
                            <hr>
                            <small class="text-muted d-block fw-bold">Download URL:</small>
                            <a href="<?php echo $row['url']; ?>" target="_blank" class="text-truncate d-block"><?php echo $row['url']; ?></a>
                        </div>

                        <form method="POST" class="mt-4">
                            <button type="submit" name="remove_update" class="btn btn-remove" onclick="return confirm('Stop this update?');">
                                <i class="fas fa-times-circle me-2"></i> REMOVE UPDATE
                            </button>
                        </form>

                    <?php } else { ?>
                        
                        <!-- যদি কোনো আপডেট না থাকে (Off Mode) -->
                        <div class="status-box status-off">
                            <i class="fas fa-pause-circle icon-large"></i>
                            <h5>No Update Active</h5>
                            <small>Users are using the default version.</small>
                        </div>

                        <!-- Update Form -->
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">New Version Code</label>
                                <input type="text" name="version" class="form-control" placeholder=" " required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">What's New (Note)</label>
                                <textarea name="note" class="form-control" rows="3" placeholder=" " required></textarea>
                            </div>

                            <div class="mb-4">
                                <label class="form-label">App Link (URL)</label>
                                <input type="url" name="url" class="form-control" placeholder=" " required>
                            </div>

                            <button type="submit" name="send_update" class="btn btn-send">
                                <i class="fas fa-paper-plane me-2"></i> SEND UPDATE
                            </button>
                        </form>

                    <?php } ?>

                </div>
            </div>
        </div>
    </div>

</body>
</html>