<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";

// আপডেট লজিক
if(isset($_POST['update_slider'])){
    $i1 = mysqli_real_escape_string($conn, $_POST['i1']);
    $l1 = mysqli_real_escape_string($conn, $_POST['l1']);
    $i2 = mysqli_real_escape_string($conn, $_POST['i2']);
    $l2 = mysqli_real_escape_string($conn, $_POST['l2']);
    $i3 = mysqli_real_escape_string($conn, $_POST['i3']);
    $l3 = mysqli_real_escape_string($conn, $_POST['l3']);
    $i4 = mysqli_real_escape_string($conn, $_POST['i4']);
    $l4 = mysqli_real_escape_string($conn, $_POST['l4']);

    $sql_update = "UPDATE app_slider SET i1='$i1', l1='$l1', i2='$i2', l2='$l2', i3='$i3', l3='$l3', i4='$i4', l4='$l4' WHERE id=1";

    if($conn->query($sql_update)){
        $msg = "<div class='alert alert-success border-0 shadow-sm text-center fw-bold rounded-3 mb-4'>Changes Saved Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-danger'>Error: " . $conn->error . "</div>";
    }
}

// ডাটা আনা
$sql_fetch = "SELECT * FROM app_slider WHERE id=1";
$result = $conn->query($sql_fetch);
if($result->num_rows > 0){ $row = $result->fetch_assoc(); } 
else { 
    $conn->query("INSERT INTO app_slider (id) VALUES (1)"); 
    $row = array('i1'=>'','l1'=>'','i2'=>'','l2'=>'','i3'=>'','l3'=>'','i4'=>'','l4'=>''); 
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Sliders</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { background: #f0f2f5; font-family: 'Urbanist', sans-serif; padding-bottom: 100px; }
        
        /* Navbar */
        .header-bar {
            background: white; padding: 15px 20px;
            display: flex; align-items: center; justify-content: space-between;
            position: sticky; top: 0; z-index: 999;
            box-shadow: 0 4px 20px rgba(0,0,0,0.03);
        }
        .header-title { font-size: 18px; font-weight: 700; color: #1a1a1a; margin: 0; }
        .btn-back {
            width: 40px; height: 40px; border-radius: 12px; background: #f5f5f5;
            display: flex; align-items: center; justify-content: center; color: #333;
            text-decoration: none; transition: 0.3s;
        }
        .btn-back:hover { background: #333; color: white; }

        /* Slider Card Design */
        .slider-box {
            background: white; border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.04);
            margin-bottom: 25px; overflow: hidden;
            border: 1px solid #f0f0f0;
        }

        /* Image Preview Area */
        .preview-container {
            width: 100%; height: 180px;
            background-color: #eef2f6;
            background-image: radial-gradient(#dfe6e9 1px, transparent 1px);
            background-size: 20px 20px;
            position: relative; overflow: hidden;
            display: flex; align-items: center; justify-content: center;
        }
        .preview-img { width: 100%; height: 100%; object-fit: cover; transition: 0.3s; }
        .slide-badge {
            position: absolute; top: 15px; left: 15px;
            background: rgba(0,0,0,0.7); color: white;
            padding: 5px 12px; border-radius: 8px;
            font-size: 11px; font-weight: 700; text-transform: uppercase;
            letter-spacing: 1px; z-index: 5;
        }
        .placeholder-icon { color: #cbd5e1; font-size: 40px; position: absolute; z-index: 1; }

        /* Input Styling */
        .box-body { padding: 25px; }
        .label-custom { font-size: 12px; font-weight: 700; color: #636e72; text-transform: uppercase; margin-bottom: 8px; display: block; }
        
        .custom-input-group {
            position: relative; display: flex; align-items: center;
            border: 2px solid #f1f2f6; border-radius: 12px;
            background: #fdfdfd; overflow: hidden; transition: 0.3s;
        }
        .custom-input-group:focus-within { border-color: #6c5ce7; box-shadow: 0 0 0 4px rgba(108, 92, 231, 0.1); background: white; }
        
        .input-icon-box {
            padding: 0 15px; color: #b2bec3; font-size: 14px;
            display: flex; align-items: center; height: 100%;
            background: #fdfdfd; border-right: 1px solid #f1f2f6;
        }
        
        .input-field {
            border: none; background: transparent; width: 100%;
            padding: 14px 15px; font-size: 14px; color: #2d3436; outline: none;
        }

        /* Save Button */
        .sticky-footer {
            position: fixed; bottom: 20px; left: 0; right: 0;
            padding: 0 20px; z-index: 99; display: flex; justify-content: center;
        }
        .btn-save-main {
            background: #1a1a1a; color: white; border: none;
            padding: 16px 40px; border-radius: 50px;
            font-size: 16px; font-weight: 700; letter-spacing: 0.5px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2); width: 100%; max-width: 600px;
            transition: 0.3s;
        }
        .btn-save-main:hover { transform: translateY(-3px); box-shadow: 0 15px 40px rgba(0,0,0,0.3); }

    </style>
</head>
<body>

    <div class="header-bar">
        <a href="dashboard.php" class="btn-back"><i class="fas fa-arrow-left"></i></a>
        <h2 class="header-title">Slider Manager</h2>
        <div style="width: 40px;"></div> <!-- Spacer -->
    </div>

    <div class="container mt-4">
        <?php echo $msg; ?>

        <form method="POST">
            <div class="row">
                
                <!-- Loop for 4 sliders -->
                <?php for ($i = 1; $i <= 4; $i++) { ?>
                <div class="col-md-6">
                    <div class="slider-box">
                        
                        <!-- Preview -->
                        <div class="preview-container">
                            <span class="slide-badge">Slide <?php echo $i; ?></span>
                            <i class="far fa-image placeholder-icon"></i>
                            <img id="preview<?php echo $i; ?>" src="<?php echo $row['i'.$i]; ?>" class="preview-img" onerror="this.style.opacity='0'">
                        </div>

                        <div class="box-body">
                            
                            <!-- Image URL Input -->
                            <div class="mb-3">
                                <label class="label-custom">Banner Image URL</label>
                                <div class="custom-input-group">
                                    <span class="input-icon-box"><i class="fas fa-link"></i></span>
                                    <input type="text" name="i<?php echo $i; ?>" id="inputImg<?php echo $i; ?>" 
                                           class="input-field" placeholder="Paste image link here..." 
                                           value="<?php echo $row['i'.$i]; ?>" 
                                           oninput="updatePreview('preview<?php echo $i; ?>', this.value)">
                                </div>
                            </div>

                            <!-- Target Link -->
                            <div class="mb-0">
                                <label class="label-custom">Action / Target Link</label>
                                <div class="custom-input-group">
                                    <span class="input-icon-box"><i class="fas fa-external-link-alt"></i></span>
                                    <input type="text" name="l<?php echo $i; ?>" class="input-field" 
                                           placeholder="Ex: https://google.com or Activity" 
                                           value="<?php echo $row['l'.$i]; ?>">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <?php } ?>

            </div>
            
            <div style="height: 60px;"></div>

            <!-- Sticky Save Button -->
            <div class="sticky-footer">
                <button type="submit" name="update_slider" class="btn-save-main">
                    Save Changes
                </button>
            </div>

        </form>
    </div>

    <!-- JS Logic for Preview -->
    <script>
        // Preview Update Function
        function updatePreview(imgId, url) {
            var img = document.getElementById(imgId);
            if(url.trim() !== "") {
                img.src = url;
                img.style.opacity = '1';
            } else {
                img.style.opacity = '0';
            }
        }

        // Load Previews on Page Load
        window.onload = function() {
            for(let i=1; i<=4; i++) {
                let img = document.getElementById('preview'+i);
                if(img.src && img.src !== window.location.href) {
                    img.style.opacity = '1';
                } else {
                    img.style.opacity = '0';
                }
            }
        };
    </script>

</body>
</html>