<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";

// --- 1. UPDATE SETTINGS LOGIC ---
if(isset($_POST['update_settings'])){
    $bkash = mysqli_real_escape_string($conn, $_POST['bkash']);
    $nagad = mysqli_real_escape_string($conn, $_POST['nagad']);
    $rocket = mysqli_real_escape_string($conn, $_POST['rocket']);
    $link1 = mysqli_real_escape_string($conn, $_POST['link1']);
    $link2 = mysqli_real_escape_string($conn, $_POST['link2']);

    // ডাটাবেস আপডেট (id=1 ফিক্সড)
    $sql_update = "UPDATE app_settings SET 
                   bkash='$bkash', 
                   nagad='$nagad', 
                   rocket='$rocket', 
                   link1='$link1', 
                   link2='$link2' 
                   WHERE id=1";

    if($conn->query($sql_update)){
        $msg = "<div class='alert alert-success shadow-sm border-0'><i class='fas fa-check-circle me-2'></i>Settings Updated Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-danger shadow-sm border-0'>Error: " . $conn->error . "</div>";
    }
}

// --- 2. FETCH DATA ---
$sql_fetch = "SELECT * FROM app_settings WHERE id=1";
$result = $conn->query($sql_fetch);

if($result->num_rows > 0){
    $row = $result->fetch_assoc();
} else {
    // যদি ডাটাবেস খালি থাকে, তবে অটোমেটিক একটি রো তৈরি করে নেবে
    $conn->query("INSERT INTO app_settings (id, bkash, nagad, rocket, link1, link2) VALUES (1, '', '', '', '', '')");
    $row = array('bkash'=>'','nagad'=>'','rocket'=>'','link1'=>'','link2'=>'');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Settings</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body { background: #f4f7f6; font-family: 'Poppins', sans-serif; }
        
        /* Navbar */
        .custom-nav { background: #2c3e50; padding: 15px 0; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .navbar-brand { font-weight: 600; color: white !important; font-size: 1.2rem; }

        /* Card Designs */
        .setting-card { background: white; border-radius: 15px; border: none; box-shadow: 0 5px 20px rgba(0,0,0,0.05); overflow: hidden; margin-bottom: 20px; transition: transform 0.3s; }
        .setting-card:hover { transform: translateY(-3px); }
        
        .card-header-custom { padding: 15px 20px; font-weight: 600; color: white; }
        
        /* Brand Colors */
        .header-payment { background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%); }
        .header-links { background: linear-gradient(135deg, #4b6cb7 0%, #182848 100%); }

        /* Input Fields with Icons */
        .input-group-text { border: none; color: white; width: 45px; justify-content: center; }
        .form-control { height: 50px; border-radius: 0 10px 10px 0; border: 1px solid #eee; background: #fcfcfc; }
        .form-control:focus { box-shadow: none; border-color: #ddd; background: #fff; }

        /* Specific Brand Inputs */
        .bkash-bg { background: #e2136e; } /* Bkash Pink */
        .nagad-bg { background: #ec1c24; } /* Nagad Orange/Red */
        .rocket-bg { background: #8c3494; } /* Rocket Purple */
        .link-bg { background: #34495e; }

        /* Button */
        .btn-save { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); border: none; padding: 12px; width: 100%; border-radius: 10px; font-weight: 600; font-size: 16px; transition: 0.3s; }
        .btn-save:hover { box-shadow: 0 5px 15px rgba(56, 239, 125, 0.4); transform: translateY(-2px); }
    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-dark custom-nav mb-4">
        <div class="container">
            <span class="navbar-brand"><i class="fas fa-cogs me-2"></i>App Settings</span>
            <a href="dashboard.php" class="btn btn-outline-light btn-sm rounded-pill px-3">Back Home</a>
        </div>
    </nav>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                
                <?php echo $msg; ?>

                <form method="POST">
                    
                    <!-- 1. Payment Methods Section -->
                    <div class="setting-card">
                        <div class="card-header-custom header-payment">
                            <i class="fas fa-wallet me-2"></i> Payment Information
                        </div>
                        <div class="card-body p-4">
                            
                            <!-- Bkash -->
                            <div class="mb-4">
                                <label class="text-muted small mb-1 fw-bold">Bkash Number</label>
                                <div class="input-group">
                                    <span class="input-group-text bkash-bg"><i class="fas fa-money-bill-wave"></i></span>
                                    <input type="text" name="bkash" class="form-control" value="<?php echo $row['bkash']; ?>" placeholder="Enter Bkash Number">
                                </div>
                            </div>

                            <!-- Nagad -->
                            <div class="mb-4">
                                <label class="text-muted small mb-1 fw-bold">Nagad Number</label>
                                <div class="input-group">
                                    <span class="input-group-text nagad-bg"><i class="fas fa-mobile-alt"></i></span>
                                    <input type="text" name="nagad" class="form-control" value="<?php echo $row['nagad']; ?>" placeholder="Enter Nagad Number">
                                </div>
                            </div>

                            <!-- Rocket -->
                            <div class="mb-2">
                                <label class="text-muted small mb-1 fw-bold">Rocket Number</label>
                                <div class="input-group">
                                    <span class="input-group-text rocket-bg"><i class="fas fa-paper-plane"></i></span>
                                    <input type="text" name="rocket" class="form-control" value="<?php echo $row['rocket']; ?>" placeholder="Enter Rocket Number">
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- 2. Important Links Section -->
                    <div class="setting-card">
                        <div class="card-header-custom header-links">
                            <i class="fas fa-link me-2"></i> Important Links
                        </div>
                        <div class="card-body p-4">
                            
                            <!-- Link 1 -->
                            <div class="mb-4">
                                <label class="text-muted small mb-1 fw-bold">Link 1 (Telegram/WhatsApp)</label>
                                <div class="input-group">
                                    <span class="input-group-text link-bg"><i class="fab fa-telegram-plane"></i></span>
                                    <input type="text" name="link1" class="form-control" value="<?php echo $row['link1']; ?>" placeholder="https://t.me/yourchannel">
                                </div>
                            </div>

                            <!-- Link 2 -->
                            <div class="mb-2">
                                <label class="text-muted small mb-1 fw-bold">Link 2 (YouTube/Other)</label>
                                <div class="input-group">
                                    <span class="input-group-text link-bg"><i class="fab fa-youtube"></i></span>
                                    <input type="text" name="link2" class="form-control" value="<?php echo $row['link2']; ?>" placeholder="https://youtube.com/yourchannel">
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="d-grid gap-2 mb-5">
                        <button type="submit" name="update_settings" class="btn btn-primary btn-save text-white shadow">
                            <i class="fas fa-save me-2"></i> UPDATE SETTINGS
                        </button>
                    </div>

                </form>

            </div>
        </div>
    </div>

</body>
</html>