<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'add'; // ডিফল্ট ট্যাব 'add'

// --- DELETE PACKAGE ---
if(isset($_GET['delete_id'])){
    $id = $_GET['delete_id'];
    $sql_del = "DELETE FROM offers WHERE id='$id'";
    if($conn->query($sql_del)){
        $msg = "<div class='alert alert-danger shadow-sm border-0'>Package Deleted!</div>";
        $active_tab = 'view'; // ডিলিট করলে অটোমেটিক View ট্যাবে নিয়ে যাবে
    }
}

// --- ADD PACKAGE ---
if(isset($_POST['add_package'])){
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $note = mysqli_real_escape_string($conn, $_POST['note']);
    $amount = mysqli_real_escape_string($conn, $_POST['amount']);
    $meyad = mysqli_real_escape_string($conn, $_POST['meyad']);
    $r_amount = mysqli_real_escape_string($conn, $_POST['r_amount']);
    
    if(!empty($_POST['operator'])){
        foreach($_POST['operator'] as $selected_op){
            $sql = "INSERT INTO offers (operator, title, note, amount, meyad, r_amount) 
                    VALUES ('$selected_op', '$title', '$note', '$amount', '$meyad', '$r_amount')";
            $conn->query($sql);
        }
        $msg = "<div class='alert alert-success shadow-sm border-0'>Offer Added Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-warning shadow-sm border-0'>Please select an Operator!</div>";
    }
}

// --- SHOW PACKAGES ---
$current_view = isset($_GET['op']) ? $_GET['op'] : 'BL';
// যদি অপারেটর সিলেক্ট করা হয়, তবে অটোমেটিক View ট্যাবে থাকবে
if(isset($_GET['op'])) { $active_tab = 'view'; }

$sql_show = "SELECT * FROM offers WHERE operator='$current_view' ORDER BY id DESC";
$result = $conn->query($sql_show);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Drive Manager</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        body { background-color: #f8f9fe; font-family: 'Poppins', sans-serif; }
        
        /* Main Container */
        .main-container { max-width: 800px; margin: 30px auto; }

        /* Custom Tabs */
        .custom-tabs {
            background: white;
            padding: 10px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.03);
            display: flex;
            justify-content: space-between;
            margin-bottom: 25px;
        }
        
        .tab-btn {
            flex: 1;
            text-align: center;
            padding: 12px;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            color: #8898aa;
            transition: 0.3s;
        }
        
        .tab-btn:hover { background: #f6f9fc; color: #5e72e4; }
        
        /* Active Tab Design */
        .tab-btn.active {
            background: linear-gradient(135deg, #5e72e4 0%, #825ee4 100%);
            color: white;
            box-shadow: 0 4px 10px rgba(94, 114, 228, 0.3);
        }

        /* Forms & Cards */
        .content-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            padding: 30px;
            border: none;
        }

        /* Inputs */
        .form-label { font-size: 14px; font-weight: 500; color: #525f7f; margin-bottom: 8px; }
        .form-control {
            border-radius: 10px;
            padding: 12px 15px;
            border: 1px solid #e9ecef;
            background: #fdfdfd;
            font-size: 15px;
        }
        .form-control:focus { border-color: #5e72e4; box-shadow: none; background: white; }

        /* Operator Selector */
        .op-selector { display: flex; gap: 10px; flex-wrap: wrap; margin-top: 5px; }
        .op-selector input { display: none; }
        .op-selector label {
            padding: 8px 18px;
            background: #f4f5f7;
            border-radius: 30px;
            cursor: pointer;
            font-size: 13px;
            font-weight: 600;
            color: #8898aa;
            transition: 0.3s;
            border: 1px solid transparent;
        }
        
        /* Checkbox Active Colors */
        .op-selector input:checked + label[for="bl"] { background: #FF6B6B; color: white; box-shadow: 0 3px 8px rgba(255,107,107,0.3); }
        .op-selector input:checked + label[for="gp"] { background: #00b894; color: white; box-shadow: 0 3px 8px rgba(0,184,148,0.3); }
        .op-selector input:checked + label[for="rb"] { background: #ff3838; color: white; box-shadow: 0 3px 8px rgba(255,56,56,0.3); }
        .op-selector input:checked + label[for="ar"] { background: #ed4c67; color: white; box-shadow: 0 3px 8px rgba(237,76,103,0.3); }
        .op-selector input:checked + label[for="tt"] { background: #0984e3; color: white; box-shadow: 0 3px 8px rgba(9,132,227,0.3); }
        .op-selector input:checked + label[for="sk"] { background: #a29bfe; color: white; box-shadow: 0 3px 8px rgba(162,155,254,0.3); }

        /* Buttons */
        .btn-add-offer {
            background: linear-gradient(135deg, #11cdef 0%, #1171ef 100%);
            border: none; width: 100%; padding: 14px; border-radius: 12px;
            font-weight: 600; color: white; font-size: 16px; margin-top: 10px;
            transition: 0.3s;
        }
        .btn-add-offer:hover { transform: translateY(-3px); box-shadow: 0 5px 15px rgba(17, 113, 239, 0.3); }

        .btn-back-dashboard {
            background: #f7fafc; color: #525f7f; border: 1px solid #e9ecef;
            width: 100%; padding: 12px; border-radius: 12px; font-weight: 600;
            margin-top: 15px; text-decoration: none; display: block; text-align: center;
            transition: 0.3s;
        }
        .btn-back-dashboard:hover { background: #e9ecef; }

        /* View Drive Styles */
        .op-tabs { display: flex; justify-content: center; gap: 5px; flex-wrap: wrap; margin-bottom: 20px; }
        .op-tabs a {
            padding: 8px 16px; border-radius: 20px; text-decoration: none;
            font-size: 13px; font-weight: 600; color: #525f7f; background: #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05); transition: 0.3s;
        }
        .op-tabs a.active { background: #5e72e4; color: white; }

        .offer-item {
            display: flex; justify-content: space-between; align-items: center;
            padding: 15px; border-bottom: 1px solid #f0f0f0; transition: 0.2s;
        }
        .offer-item:last-child { border-bottom: none; }
        .offer-item:hover { background: #fcfcfc; }
        .offer-price { font-weight: 700; color: #2dce89; font-size: 16px; }
        .offer-validity { font-size: 12px; color: #8898aa; }

    </style>
</head>
<body>

    <div class="main-container">
        
        <h4 class="text-center mb-4 fw-bold" style="color: #32325d;">Offer Management</h4>
        <?php echo $msg; ?>

        <!-- 1. TOP TABS (Add vs View) -->
        <div class="custom-tabs">
            <a href="packages.php?tab=add" class="tab-btn <?php if($active_tab == 'add') echo 'active'; ?>">
                <i class="fas fa-plus-circle me-2"></i>Add Drive
            </a>
            <a href="packages.php?tab=view" class="tab-btn <?php if($active_tab == 'view') echo 'active'; ?>">
                <i class="fas fa-list-ul me-2"></i>View Drive
            </a>
        </div>


        <!-- 2. ADD DRIVE SECTION -->
        <?php if($active_tab == 'add') { ?>
        <div class="content-card">
            <form method="POST">
                
                <div class="mb-3">
                    <label class="form-label">Offer Title</label>
                    <input type="text" name="title" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Note / Details (Optional)</label>
                    <input type="text" name="note" class="form-control">
                </div>

                <div class="row">
                    <div class="col-6 mb-3">
                        <label class="form-label">Offer Price</label>
                        <input type="number" name="amount" class="form-control" required>
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label">Regular Price</label>
                        <input type="number" name="r_amount" class="form-control">
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Validity (Meyad)</label>
                    <input type="text" name="meyad" class="form-control" required>
                </div>

                <div class="mb-4">
                    <label class="form-label d-block fw-bold">Select Operator</label>
                    <div class="op-selector">
                        <input type="checkbox" name="operator[]" value="BL" id="bl"> <label for="bl">BL</label>
                        <input type="checkbox" name="operator[]" value="GP" id="gp"> <label for="gp">GP</label>
                        <input type="checkbox" name="operator[]" value="RB" id="rb"> <label for="rb">RB</label>
                        <input type="checkbox" name="operator[]" value="AT" id="ar"> <label for="ar">AT</label>
                        <input type="checkbox" name="operator[]" value="TT" id="tt"> <label for="tt">TT</label>
                        <input type="checkbox" name="operator[]" value="SK" id="sk"> <label for="sk">SK</label>
                    </div>
                </div>

                <button type="submit" name="add_package" class="btn-add-offer">
                    ADD OFFER
                </button>

                <a href="dashboard.php" class="btn-back-dashboard">
                    <i class="fas fa-arrow-left me-2"></i> Back to Dashboard
                </a>

            </form>
        </div>
        <?php } ?>


        <!-- 3. VIEW DRIVE SECTION -->
        <?php if($active_tab == 'view') { ?>
        <div class="content-card p-0 overflow-hidden">
            
            <div class="p-4 pb-2 bg-light border-bottom">
                <h6 class="text-center mb-3 text-uppercase text-muted fw-bold small">Filter by Operator</h6>
                <div class="op-tabs">
                    <a href="packages.php?tab=view&op=BL" class="<?php if($current_view=='BL') echo 'active'; ?>">BL</a>
                    <a href="packages.php?tab=view&op=GP" class="<?php if($current_view=='GP') echo 'active'; ?>">GP</a>
                    <a href="packages.php?tab=view&op=RB" class="<?php if($current_view=='RB') echo 'active'; ?>">RB</a>
                    <a href="packages.php?tab=view&op=AT" class="<?php if($current_view=='AT') echo 'active'; ?>">AT</a>
                    <a href="packages.php?tab=view&op=TT" class="<?php if($current_view=='TT') echo 'active'; ?>">TT</a>
                    <a href="packages.php?tab=view&op=SK" class="<?php if($current_view=='SK') echo 'active'; ?>">SK</a>
                </div>
            </div>

            <div class="list-group list-group-flush">
                <?php if($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) { ?>
                    
                    <div class="offer-item">
                        <div>
                            <div class="fw-bold text-dark mb-1"><?php echo $row['title']; ?></div>
                            <small class="text-muted d-block"><?php echo $row['note']; ?></small>
                            <span class="offer-validity"><i class="far fa-clock me-1"></i> <?php echo $row['meyad']; ?></span>
                        </div>
                        <div class="text-end">
                            <div class="offer-price mb-2">৳ <?php echo $row['amount']; ?></div>
                            <a href="packages.php?delete_id=<?php echo $row['id']; ?>&op=<?php echo $current_view; ?>" class="btn btn-sm btn-outline-danger border-0" onclick="return confirm('Delete this offer?');">
                                <i class="fas fa-trash-alt"></i>
                            </a>
                        </div>
                    </div>

                <?php }} else { ?>
                    <div class="text-center py-5">
                        <i class="fas fa-box-open text-muted mb-2" style="font-size: 30px;"></i>
                        <p class="text-muted small">No offers found for <?php echo $current_view; ?></p>
                    </div>
                <?php } ?>
            </div>
            
            <div class="p-3 bg-light border-top">
                <a href="dashboard.php" class="btn btn-sm btn-secondary w-100">Back to Dashboard</a>
            </div>

        </div>
        <?php } ?>

    </div>
    <br><br>

</body>
</html>