<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";

// --- 1. UPDATE ORDER STATUS (FIXED LOGIC) ---
if(isset($_POST['update_status'])){
    $id = $_POST['order_id'];
    
    // আগের ভুল: $status = $_POST['status_val']; 
    // সমাধান: সরাসরি বাটনের ভ্যালু নেওয়া হচ্ছে
    $status = $_POST['update_status']; 
    
    $sql_update = "UPDATE orders SET Process='$status' WHERE id='$id'";
    
    if($conn->query($sql_update)){
        if($status == 'Success'){
            $msg = "<div class='alert alert-success shadow-sm border-0 fw-bold'><i class='fas fa-check-circle me-2'></i>Order Completed Successfully!</div>";
        } else {
            $msg = "<div class='alert alert-danger shadow-sm border-0 fw-bold'><i class='fas fa-times-circle me-2'></i>Order Cancelled!</div>";
        }
    } else {
        $msg = "<div class='alert alert-warning'>Error: " . $conn->error . "</div>";
    }
}

// --- 2. FILTER LOGIC ---
$current_status = isset($_GET['view']) ? $_GET['view'] : 'Pending';
$sql = "SELECT * FROM orders WHERE Process='$current_status' ORDER BY id DESC";
$result = $conn->query($sql);

// কালার স্কিম সেট করা
$theme_color = "primary"; 
if($current_status == 'Success') $theme_color = "success";
if($current_status == 'Fail') $theme_color = "danger";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Orders</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { background: #f4f6f9; font-family: 'Poppins', sans-serif; }
        
        /* Top Navigation */
        .top-bar {
            background: white; padding: 15px 20px;
            display: flex; justify-content: space-between; align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.03); margin-bottom: 20px;
        }
        .page-title { font-weight: 700; color: #333; font-size: 18px; margin: 0; }
        
        .btn-back {
            background: #f0f2f5; color: #555; text-decoration: none;
            width: 40px; height: 40px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            transition: 0.3s;
        }
        .btn-back:hover { background: #e4e6eb; color: #000; }

        /* Status Tabs */
        .tab-container {
            display: flex; justify-content: center; gap: 10px; margin-bottom: 25px;
        }
        .status-tab {
            padding: 10px 25px; border-radius: 30px; background: white;
            text-decoration: none; color: #666; font-weight: 600; font-size: 14px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05); transition: 0.3s; border: 1px solid transparent;
        }
        
        .status-tab.active-Pending { background: #fff8e1; color: #ff8f00; border-color: #ff8f00; }
        .status-tab.active-Success { background: #e8f5e9; color: #2e7d32; border-color: #2e7d32; }
        .status-tab.active-Fail { background: #ffebee; color: #c62828; border-color: #c62828; }

        /* ORDER CARD DESIGN */
        .order-card {
            background: white; border-radius: 16px; margin-bottom: 20px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.04); overflow: hidden;
            border: 1px solid #f0f0f0; position: relative;
        }

        .card-top {
            padding: 15px 20px; border-bottom: 1px solid #f8f9fa;
            display: flex; justify-content: space-between; align-items: center;
            background: #fafafa;
        }
        .order-id { font-weight: 700; color: #444; background: #e9ecef; padding: 4px 10px; border-radius: 6px; font-size: 12px; }
        .order-time { font-size: 12px; color: #777; font-weight: 500; }

        .card-content { padding: 20px; }

        /* Grid for Content */
        .info-grid {
            display: grid; grid-template-columns: 1fr 1fr; gap: 20px;
        }
        @media (max-width: 768px) { .info-grid { grid-template-columns: 1fr; gap: 15px; } }

        .label { font-size: 11px; text-transform: uppercase; color: #999; font-weight: 600; letter-spacing: 0.5px; margin-bottom: 3px; display: block; }
        .value { font-size: 14px; font-weight: 600; color: #333; }
        
        /* Target Number & Package Highlight */
        .main-highlight { background: #f4f7fe; padding: 12px; border-radius: 10px; border-left: 4px solid #5e72e4; }
        .target-num { font-size: 18px; font-weight: 700; color: #32325d; letter-spacing: 0.5px; }
        .pack-name { font-size: 13px; color: #525f7f; margin-top: 2px; }

        /* Payment Section */
        .payment-box { display: flex; align-items: center; gap: 10px; }
        .method-badge { background: #e2136e; color: white; padding: 2px 8px; border-radius: 4px; font-size: 10px; font-weight: 700; } 
        .nagad-badge { background: #ec1c24; }
        .rocket-badge { background: #8c3494; }
        
        .trx-id { font-family: monospace; background: #f1f3f5; padding: 3px 6px; border-radius: 4px; color: #555; font-size: 12px; }

        /* Actions Footer */
        .card-actions {
            padding: 15px 20px; border-top: 1px dashed #eee;
            display: flex; justify-content: space-between; align-items: center;
        }

        .btn-action {
            flex: 1; padding: 10px; border-radius: 10px; border: none;
            font-weight: 600; font-size: 14px; color: white;
            display: flex; align-items: center; justify-content: center; gap: 8px;
            transition: 0.3s;
        }
        .btn-success-custom { background: linear-gradient(135deg, #2dce89 0%, #2dcecc 100%); margin-right: 10px; }
        .btn-danger-custom { background: linear-gradient(135deg, #f5365c 0%, #f56036 100%); }
        
        .btn-action:hover { opacity: 0.9; transform: translateY(-2px); }

        .completed-tag { width: 100%; text-align: center; color: #2dce89; font-weight: 700; background: #eefdf3; padding: 8px; border-radius: 8px; }
        .canceled-tag { width: 100%; text-align: center; color: #f5365c; font-weight: 700; background: #fff0f0; padding: 8px; border-radius: 8px; }

        /* Operator Badge Colors */
        .op-badge { font-size: 10px; font-weight: 700; color: white; padding: 2px 6px; border-radius: 4px; vertical-align: middle; margin-left: 5px; }
        .bg-BL { background: #FF6B6B; }
        .bg-GP { background: #1dd1a1; }
        .bg-RB { background: #ff3838; }
        .bg-AT { background: #ed4c67; }
        .bg-TT { background: #00d2d3; }
        .bg-SK { background: #a29bfe; }

    </style>
</head>
<body>

    <!-- Header -->
    <div class="top-bar">
        <div class="d-flex align-items-center gap-3">
            <a href="dashboard.php" class="btn-back"><i class="fas fa-arrow-left"></i></a>
            <h1 class="page-title">Order Manager</h1>
        </div>
    </div>

    <div class="container pb-5" style="max-width: 700px;">
        <?php echo $msg; ?>

        <!-- Filter Tabs -->
        <div class="tab-container">
            <a href="orders.php?view=Pending" class="status-tab <?php if($current_status == 'Pending') echo 'active-Pending'; ?>">
                <i class="fas fa-clock me-1"></i> Pending
            </a>
            <a href="orders.php?view=Success" class="status-tab <?php if($current_status == 'Success') echo 'active-Success'; ?>">
                <i class="fas fa-check-circle me-1"></i> Success
            </a>
            <a href="orders.php?view=Fail" class="status-tab <?php if($current_status == 'Fail') echo 'active-Fail'; ?>">
                <i class="fas fa-ban me-1"></i> Canceled
            </a>
        </div>

        <!-- Orders List Loop -->
        <?php if($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) { 
                
                $methodClass = "method-badge";
                if(stripos($row['Method'], 'Nagad') !== false) $methodClass .= " nagad-badge";
                elseif(stripos($row['Method'], 'Rocket') !== false) $methodClass .= " rocket-badge";
                
                $opClass = "bg-" . $row['operator'];
        ?>

        <div class="order-card">
            
            <div class="card-top">
                <span class="order-id">ORDER #<?php echo $row['id']; ?></span>
                <span class="order-time"><i class="far fa-clock me-1"></i> <?php echo $row['Time']; ?></span>
            </div>

            <div class="card-content">
                
                <div class="info-grid">
                    
                    <div class="main-highlight">
                        <span class="label">Target Number</span>
                        <div class="target-num">
                            <?php echo $row['Offernum']; ?>
                            <span class="op-badge <?php echo $opClass; ?>"><?php echo $row['operator']; ?></span>
                        </div>
                        <div class="pack-name"><?php echo $row['Offer']; ?></div>
                    </div>

                    <div>
                        <div class="mb-3">
                            <span class="label">Payment Details</span>
                            <div class="payment-box">
                                <span class="<?php echo $methodClass; ?>"><?php echo $row['Method']; ?></span>
                                <span class="value" style="color: #2dce89;">৳ <?php echo $row['OfferPrice']; ?></span>
                            </div>
                            <div class="mt-1 small text-muted">From: <?php echo $row['Paynum']; ?></div>
                        </div>

                        <?php if(!empty($row['Trnxid'])) { ?>
                        <div>
                            <span class="label">Transaction ID</span>
                            <span class="trx-id"><?php echo $row['Trnxid']; ?></span>
                        </div>
                        <?php } ?>
                    </div>

                </div>
                
                <div class="mt-3 pt-3 border-top">
                    <span class="label">User Contact</span>
                    <span class="value"><i class="fas fa-user-circle me-1 text-muted"></i> <?php echo $row['Number']; ?></span>
                </div>

            </div>

            <!-- Actions -->
            <div class="card-actions">
                <?php if($row['Process'] == 'Pending') { ?>
                    <form method="POST" class="d-flex w-100">
                        <input type="hidden" name="order_id" value="<?php echo $row['id']; ?>">
                        
                        <!-- Fixed: Added value='Success' and value='Fail' directly to buttons -->
                        <button type="submit" name="update_status" value="Success" class="btn-action btn-success-custom" onclick="return confirm('Confirm Success?');">
                            <i class="fas fa-check"></i> Approve
                        </button>
                        
                        <div style="width: 15px;"></div>

                        <button type="submit" name="update_status" value="Fail" class="btn-action btn-danger-custom" onclick="return confirm('Confirm Cancel?');">
                            <i class="fas fa-times"></i> Reject
                        </button>
                    </form>
                <?php } else { ?>
                    <?php if($row['Process'] == 'Success') { ?>
                        <div class="completed-tag"><i class="fas fa-check-circle"></i> Completed</div>
                    <?php } else { ?>
                        <div class="canceled-tag"><i class="fas fa-times-circle"></i> Canceled</div>
                    <?php } ?>
                <?php } ?>
            </div>

        </div>

        <?php }} else { ?>
            <div class="text-center py-5 text-muted">
                <i class="fas fa-clipboard-list fa-3x mb-3 text-secondary opacity-25"></i>
                <h5>No Orders Found</h5>
                <p class="small">There are no orders in <b><?php echo $current_status; ?></b> list.</p>
            </div>
        <?php } ?>

    </div>

</body>
</html>