<?php
include 'auth.php'; 
include 'config.php'; 

$msg = "";

// --- 1. ENABLE / UPDATE MAINTENANCE ---
if(isset($_POST['enable_maintenance'])){
    $message = mysqli_real_escape_string($conn, $_POST['message']);
    $time = mysqli_real_escape_string($conn, $_POST['time']);
    
    // Status 'on' করা হবে
    $sql = "UPDATE app_maintain SET status='on', message='$message', time='$time' WHERE id=1";
    
    if($conn->query($sql)){
        $msg = "<div class='alert alert-danger shadow-sm border-0'><i class='fas fa-exclamation-triangle me-2'></i>Maintenance Mode is ON!</div>";
    } else {
        $msg = "<div class='alert alert-warning'>Error: " . $conn->error . "</div>";
    }
}

// --- 2. DISABLE MAINTENANCE (DELETE) ---
if(isset($_POST['disable_maintenance'])){
    // Status 'off' করা হবে এবং মেসেজ রিসেট হবে (আপনার অ্যাপের লজিক অনুযায়ী)
    $sql = "UPDATE app_maintain SET status='off', message='Welcome', time='' WHERE id=1";
    
    if($conn->query($sql)){
        $msg = "<div class='alert alert-success shadow-sm border-0'><i class='fas fa-check-circle me-2'></i>App is now LIVE!</div>";
    }
}

// --- 3. FETCH CURRENT STATUS ---
$sql_fetch = "SELECT * FROM app_maintain WHERE id=1";
$result = $conn->query($sql_fetch);

if($result->num_rows > 0){
    $row = $result->fetch_assoc();
} else {
    // ডিফল্ট রো তৈরি করা (যদি না থাকে)
    $conn->query("INSERT INTO app_maintain (id, status, message, time) VALUES (1, 'off', 'Welcome', '')");
    $row = array('status'=>'off', 'message'=>'Welcome', 'time'=>'');
}

// স্ট্যাটাস কালার ঠিক করা
$is_maintenance = ($row['status'] == 'on');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Maintenance</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body { background: #eef2f5; font-family: 'Poppins', sans-serif; }
        
        .custom-nav { background: #2d3436; padding: 15px 0; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .navbar-brand { font-weight: 600; color: white !important; font-size: 1.2rem; }

        /* Status Banner */
        .status-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            margin-bottom: 25px;
            border: 1px solid rgba(0,0,0,0.02);
        }
        
        .status-icon { font-size: 50px; margin-bottom: 15px; display: inline-block; }
        
        .live-mode { color: #00b894; }
        .maintain-mode { color: #ff7675; }
        
        .status-text { font-size: 24px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; }

        /* Form Design */
        .control-card { background: white; border-radius: 15px; padding: 30px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); }
        
        .form-control {
            background: #f9f9f9;
            border: 1px solid #eee;
            border-radius: 10px;
            padding: 15px;
            font-size: 15px;
        }
        .form-control:focus { background: white; box-shadow: none; border-color: #0984e3; }
        
        /* Buttons */
        .btn-enable {
            background: linear-gradient(135deg, #ff7675 0%, #d63031 100%);
            border: none; padding: 15px; width: 100%; border-radius: 10px;
            font-weight: 600; color: white; transition: 0.3s;
        }
        .btn-enable:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(214, 48, 49, 0.3); }

        .btn-disable {
            background: linear-gradient(135deg, #00b894 0%, #00cec9 100%);
            border: none; padding: 15px; width: 100%; border-radius: 10px;
            font-weight: 600; color: white; transition: 0.3s;
        }
        .btn-disable:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0, 184, 148, 0.3); }

    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-dark custom-nav mb-4">
        <div class="container">
            <span class="navbar-brand"><i class="fas fa-tools me-2"></i>Maintenance Control</span>
            <a href="dashboard.php" class="btn btn-outline-light btn-sm rounded-pill px-3">Back Home</a>
        </div>
    </nav>

    <div class="container">
        
        <!-- Status Indicator Banner -->
        <div class="row justify-content-center">
            <div class="col-md-8">
                <?php echo $msg; ?>

                <div class="status-card">
                    <?php if($is_maintenance) { ?>
                        <!-- If Maintenance is ON -->
                        <div class="status-icon maintain-mode">
                            <i class="fas fa-power-off"></i>
                        </div>
                        <div class="status-text maintain-mode">App is Under Maintenance</div>
                        <p class="text-muted mt-2">Users cannot access the app right now.</p>
                    <?php } else { ?>
                        <!-- If Maintenance is OFF -->
                        <div class="status-icon live-mode">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="status-text live-mode">App is Live</div>
                        <p class="text-muted mt-2">Everything is running smoothly.</p>
                    <?php } ?>
                </div>
            </div>
        </div>

        <!-- Control Form -->
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="control-card">
                    
                    <?php if($is_maintenance) { ?>
                        
                        <!-- DISABLE FORM (If currently ON) -->
                        <h5 class="text-center mb-4 text-success fw-bold">Turn Off Maintenance?</h5>
                        <form method="POST">
                             <div class="alert alert-light border text-center p-3 mb-4">
                                <strong>Current Message:</strong><br>
                                <?php echo $row['message']; ?><br>
                                <small class="text-muted">Time: <?php echo $row['time']; ?></small>
                             </div>
                             
                             <button type="submit" name="disable_maintenance" class="btn btn-disable">
                                <i class="fas fa-check-circle me-2"></i> GO LIVE (DELETE MAINTENANCE)
                             </button>
                        </form>

                    <?php } else { ?>

                        <!-- ENABLE FORM (If currently OFF) -->
                        <h5 class="text-center mb-4 text-danger fw-bold">Enable Maintenance Mode</h5>
                        <form method="POST">
                            <div class="mb-3">
                                <label class="fw-bold text-muted small mb-1">Reason / Message</label>
                                <textarea name="message" class="form-control" rows="3" placeholder=" " required></textarea>
                            </div>
                            
                            <div class="mb-4">
                                <label class="fw-bold text-muted small mb-1">Estimated Time</label>
                                <input type="text" name="time" class="form-control" placeholder=" " required>
                            </div>

                            <button type="submit" name="enable_maintenance" class="btn btn-enable">
                                <i class="fas fa-ban me-2"></i> TURN ON MAINTENANCE
                            </button>
                        </form>

                    <?php } ?>

                </div>
            </div>
        </div>
    </div>
    <br><br>

</body>
</html>