<?php
session_start();
include 'config.php';

// লগইন করা থাকলে ড্যাশবোর্ডে পাঠাবে
if(isset($_SESSION['admin_login'])){
    header("Location: dashboard.php");
    exit();
}

$error = "";

if(isset($_POST['login'])){
    $user = mysqli_real_escape_string($conn, $_POST['username']);
    $pass = mysqli_real_escape_string($conn, $_POST['password']);
    
    // ডাটাবেস চেক
    $sql = "SELECT * FROM admin WHERE username='$user' AND password='$pass'";
    $result = $conn->query($sql);
    
    if($result->num_rows > 0){
        $_SESSION['admin_login'] = true;
        header("Location: dashboard.php");
        exit();
    } else {
        $error = "Incorrect username or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Portal</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

    <style>
        body, html { height: 100%; margin: 0; font-family: 'Inter', sans-serif; overflow: hidden; }
        
        .main-container {
            display: flex; height: 100vh; width: 100%;
        }

        /* LEFT SIDE - IMAGE & BRANDING */
        .left-panel {
            flex: 1.2;
            background: url('https://images.unsplash.com/photo-1618005182384-a83a8bd57fbe?q=80&w=2564&auto=format&fit=crop') no-repeat center center;
            background-size: cover;
            position: relative;
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 60px;
            color: white;
        }
        
        .overlay {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background: linear-gradient(135deg, rgba(30, 60, 114, 0.85) 0%, rgba(42, 82, 152, 0.9) 100%);
            z-index: 1;
        }
        
        .brand-content { position: relative; z-index: 2; }
        .brand-title { font-size: 3rem; font-weight: 700; margin-bottom: 15px; }
        .brand-desc { font-size: 1.1rem; opacity: 0.8; font-weight: 300; max-width: 400px; line-height: 1.6; }

        /* RIGHT SIDE - LOGIN FORM */
        .right-panel {
            flex: 1;
            background: #ffffff;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 40px;
        }

        .login-box { width: 100%; max-width: 420px; }

        .form-header { margin-bottom: 40px; }
        .form-header h2 { font-weight: 700; color: #1a1a1a; font-size: 28px; }
        .form-header p { color: #666; margin-top: 10px; }

        /* Modern Inputs */
        .input-group-custom { position: relative; margin-bottom: 25px; }
        
        .form-control-custom {
            width: 100%;
            padding: 15px 15px 15px 50px;
            border: 2px solid #f0f2f5;
            background-color: #fcfcfc;
            border-radius: 12px;
            font-size: 15px;
            transition: 0.3s;
            color: #333;
        }
        .form-control-custom:focus {
            border-color: #4facfe;
            background-color: #fff;
            outline: none;
            box-shadow: 0 0 0 4px rgba(79, 172, 254, 0.1);
        }

        .field-icon {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #a0a5b9;
            font-size: 18px;
            transition: 0.3s;
        }
        
        .form-control-custom:focus + .field-icon { color: #4facfe; }

        /* Button */
        .btn-submit {
            width: 100%;
            padding: 16px;
            background: #1a1a1a;
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: 0.3s;
            margin-top: 10px;
        }
        .btn-submit:hover {
            background: #333;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }

        /* Error Alert */
        .alert-error {
            background-color: #fee2e2; color: #ef4444;
            padding: 12px; border-radius: 8px; font-size: 14px;
            margin-bottom: 20px; border-left: 4px solid #ef4444;
            display: flex; align-items: center; gap: 10px;
        }

        /* Mobile Responsive */
        @media (max-width: 900px) {
            .left-panel { display: none; }
            .right-panel { flex: 1; padding: 20px; }
        }

    </style>
</head>
<body>

    <div class="main-container">
        
        <!-- Left Side (Image & Branding) -->
        <div class="left-panel">
            <div class="overlay"></div>
            <div class="brand-content">
                <h1 class="brand-title">Control Panel.</h1>
                <p class="brand-desc">Manage your application users, packages, orders, and settings securely from one place.</p>
            </div>
        </div>

        <!-- Right Side (Form) -->
        <div class="right-panel">
            <div class="login-box">
                
                <div class="form-header">
                    <h2>Hello Again! 👋</h2>
                    <p>Welcome back, please login to your account.</p>
                </div>

                <?php if($error) { ?>
                    <div class="alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                    </div>
                <?php } ?>

                <form method="POST">
                    
                    <div class="input-group-custom">
                        <input type="text" name="username" class="form-control-custom" placeholder="Username" required>
                        <i class="fas fa-user field-icon"></i>
                    </div>

                    <div class="input-group-custom">
                        <input type="password" name="password" class="form-control-custom" placeholder="Password" required>
                        <i class="fas fa-lock field-icon"></i>
                    </div>

                    <button type="submit" name="login" class="btn-submit">
                        Sign In
                    </button>

                </form>

                <div class="text-center mt-4 text-muted small">
                    &copy; 2025 Admin Security
                </div>

            </div>
        </div>

    </div>

</body>
</html>