<?php 
include 'auth.php'; // লগইন চেক
include 'config.php'; // ডাটাবেস কানেকশন

// --- 1. COUNT TOTAL USERS ---
$sql_users = "SELECT COUNT(*) as total FROM users";
$result_users = $conn->query($sql_users);
$total_users = 0;
if($result_users){
    $row_users = $result_users->fetch_assoc();
    $total_users = $row_users['total'];
}

// --- 2. COUNT PENDING ORDERS ---
// আপনার orders টেবিলে স্ট্যাটাস কলামের নাম 'Process' এবং পেন্ডিং ভ্যালু 'Pending'
$sql_orders = "SELECT COUNT(*) as total FROM orders WHERE Process='Pending'";
$result_orders = $conn->query($sql_orders);
$pending_orders = 0;
if($result_orders){
    $row_orders = $result_orders->fetch_assoc();
    $pending_orders = $row_orders['total'];
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome (Icons) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    
    <style>
        body{ background-color: #f3f5f9; font-family: 'Poppins', sans-serif; }
        
        /* Navbar Design */
        .navbar-custom {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            padding: 15px 0;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .navbar-brand { font-weight: 700; font-size: 1.4rem; letter-spacing: 1px; }

        /* Stats Card (Counter) Design */
        .stat-card {
            border-radius: 15px;
            border: none;
            color: white;
            padding: 25px 20px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stat-card:hover { transform: translateY(-5px); }
        
        .bg-users { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .bg-orders { background: linear-gradient(135deg, #ff9966 0%, #ff5e62 100%); }
        
        .stat-count { font-size: 2.5rem; font-weight: 700; margin-bottom: 0; }
        .stat-title { font-size: 1rem; opacity: 0.9; text-transform: uppercase; letter-spacing: 1px; }
        .stat-icon { position: absolute; right: 20px; top: 50%; transform: translateY(-50%); font-size: 3.5rem; opacity: 0.3; }

        /* Menu Grid Design */
        .menu-card {
            background: white;
            border-radius: 15px;
            padding: 25px 15px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.03);
            transition: all 0.3s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-decoration: none;
            color: #444;
            border: 1px solid rgba(0,0,0,0.02);
        }

        .menu-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
            color: #2a5298; /* Hover Color */
        }

        .menu-icon {
            font-size: 35px;
            margin-bottom: 15px;
            padding: 15px;
            border-radius: 50%;
            background: #f0f2f5;
            color: #2a5298;
            transition: 0.3s;
        }

        .menu-card:hover .menu-icon {
            background: #2a5298;
            color: white;
        }
        
        .menu-title { font-weight: 600; font-size: 15px; }

        .section-title { font-weight: 600; color: #555; margin-bottom: 20px; border-left: 5px solid #2a5298; padding-left: 15px; }
    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-dark navbar-custom mb-5">
        <div class="container">
            <span class="navbar-brand"><i class="fas fa-shield-alt me-2"></i>Admin Panel</span>
            <a href="logout.php" class="btn btn-light btn-sm rounded-pill px-4 fw-bold text-danger">Logout <i class="fas fa-sign-out-alt ms-1"></i></a>
        </div>
    </nav>

    <div class="container">
        
        <!-- SECTION 1: LIVE STATS -->
        <h5 class="section-title">Dashboard Overview</h5>
        <div class="row mb-5">
            
            <!-- Total Users Card -->
            <div class="col-md-6 mb-3">
                <div class="stat-card bg-users">
                    <div class="stat-title">Total Users</div>
                    <div class="stat-count"><?php echo $total_users; ?></div>
                    <i class="fas fa-users stat-icon"></i>
                </div>
            </div>

            <!-- Pending Orders Card -->
            <div class="col-md-6 mb-3">
                <div class="stat-card bg-orders">
                    <div class="stat-title">Pending Orders</div>
                    <div class="stat-count"><?php echo $pending_orders; ?></div>
                    <i class="fas fa-shopping-cart stat-icon"></i>
                </div>
            </div>

        </div>

        <!-- SECTION 2: MENU GRID -->
        <h5 class="section-title">Quick Actions</h5>
        <div class="row g-4 mb-5">
            
            <!-- 1. All Users -->
            <div class="col-6 col-md-3">
                <a href="users.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-user-friends"></i></div>
                    <div class="menu-title">All User's</div>
                </a>
            </div>

            <!-- 2. Drive Add (Packages) -->
            <div class="col-6 col-md-3">
                <a href="packages.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-plus-circle"></i></div>
                    <div class="menu-title">Drive Add</div>
                </a>
            </div>

            <!-- 3. Drive Order -->
            <div class="col-6 col-md-3">
                <a href="orders.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-cart-arrow-down"></i></div>
                    <div class="menu-title">Drive Order</div>
                </a>
            </div>

            <!-- 4. App Setting -->
            <div class="col-6 col-md-3">
                <a href="settings.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-cogs"></i></div>
                    <div class="menu-title">App Setting</div>
                </a>
            </div>

            <!-- 5. App Notice -->
            <div class="col-6 col-md-3">
                <a href="notice.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-bell"></i></div>
                    <div class="menu-title">App Notice</div>
                </a>
            </div>

            <!-- 6. App Maintain -->
            <div class="col-6 col-md-3">
                <a href="maintain.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-tools"></i></div>
                    <div class="menu-title">App Maintain</div>
                </a>
            </div>

            <!-- 7. Image Slider -->
            <div class="col-6 col-md-3">
                <a href="slider.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-images"></i></div>
                    <div class="menu-title">Image Slider</div>
                </a>
            </div>
          
           <!-- 9. Admin Profile -->
            <div class="col-6 col-md-3">
                <a href="admin_profile.php" class="menu-card">
                <div class="menu-icon"><i class="fas fa-user-lock"></i></div>
                <div class="menu-title">Admin Profile</div>
               </a>
            </div>

            <!-- 8. App Update -->
            <div class="col-6 col-md-3">
                <a href="update.php" class="menu-card">
                    <div class="menu-icon"><i class="fas fa-cloud-upload-alt"></i></div>
                    <div class="menu-title">App Update</div>
                </a>
            </div>

        </div>
    </div>
    
</body>
</html>